/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.common;

import com.ibm.hsc.auiml.databeans.common.TreeTableDisplay;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.NodeDescriptor;
import com.ibm.ui.framework.TaskDefinitionException;
import com.ibm.ui.framework.TreeTableNodeDescriptor;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class TreeTable {
    public static final boolean DEBUG = true;
    public static final String DB_STRING = "@@@@@@@@ TreeTable @@@@@@@@\n";
    public static final String KEY_SEPARATOR = "~";
    private List m_columnList;
    private Hashtable m_ioTable;
    private TreeTableNodeDescriptor m_rootNode;
    private String m_rootName;
    private DataBean m_ioBean;
    private int m_numColumns;
    private UserTaskManager m_utm;
    private String m_rootKey;
    private HashMap m_nodeList = new HashMap();

    public TreeTable(TreeTableDisplay treeTableDisplay, List list) {
        this.m_numColumns = list.size();
        this.m_columnList = list;
        this.m_rootName = treeTableDisplay.getKey();
        this.m_rootKey = this.m_rootName + KEY_SEPARATOR;
        if (treeTableDisplay != null) {
            this.m_rootNode = this.setRoot(treeTableDisplay, true);
        }
    }

    public String getRootName() {
        return this.m_rootName;
    }

    public void setUTM(UserTaskManager userTaskManager) {
        this.m_utm = userTaskManager;
    }

    public TreeTableNodeDescriptor setRoot(TreeTableDisplay treeTableDisplay, boolean bl) {
        TreeTableNodeDescriptor treeTableNodeDescriptor = this.getTableDescriptor(treeTableDisplay);
        treeTableNodeDescriptor.setExpandRequested(true);
        treeTableNodeDescriptor.setUserObject((Object)treeTableDisplay);
        treeTableNodeDescriptor.setLeaf(false);
        return treeTableNodeDescriptor;
    }

    private TreeTableNodeDescriptor createNode(String string, String string2, ItemDescriptor[] itemDescriptorArray, String string3, TreeTableDisplay treeTableDisplay) {
        if (IDebug.enabled()) {
            System.err.println("@@@@@@@@ TreeTable @@@@@@@@\n createNode() <<<<<<");
        }
        if (this.m_rootKey != null && !string.equals(this.m_rootName)) {
            string = this.m_rootKey + string;
        }
        TreeTableNodeDescriptor treeTableNodeDescriptor = string3 == null ? new TreeTableNodeDescriptor(string, string2, itemDescriptorArray) : new TreeTableNodeDescriptor(string, string2, itemDescriptorArray, string3, string3);
        if (IDebug.enabled()) {
            System.err.println("%%%%%%%%% START %%%%%%%%%%%%%%");
            System.err.println("Node >>>>>");
            System.err.println("Name = " + treeTableNodeDescriptor.getName() + "\n" + "Title = " + treeTableNodeDescriptor.getTitle() + "\n" + "Row Data : ");
            for (int i = 0; i < itemDescriptorArray.length; ++i) {
                System.err.println("Item Name : " + itemDescriptorArray[i].getName() + " Item Title : " + itemDescriptorArray[i].getTitle());
            }
            System.err.println("%%%%%%%%%%% END %%%%%%%%%%%%%%%\n\n");
        }
        treeTableNodeDescriptor.setUserObject((Object)treeTableDisplay);
        this.m_nodeList.put(treeTableDisplay.getKey(), treeTableNodeDescriptor);
        return treeTableNodeDescriptor;
    }

    public TreeTableNodeDescriptor[] getChildren(TreeTableNodeDescriptor treeTableNodeDescriptor) {
        if (treeTableNodeDescriptor == null) {
            System.err.println("Returnin root node : " + this.m_rootNode + "\n");
            return new TreeTableNodeDescriptor[]{this.m_rootNode};
        }
        TreeTableDisplay treeTableDisplay = (TreeTableDisplay)treeTableNodeDescriptor.getUserObject();
        if (IDebug.enabled()) {
            System.err.println("Calling GetChidlren with : parent >>>" + treeTableNodeDescriptor.getName() + "<<<");
            System.err.println(">>>>>>>>>>>>>>> Current Tree>>>>>>>>>>>>>>>>>>>>>\n\n");
            this.printTree();
            System.err.println("User Object >>" + treeTableDisplay.getKey() + "<<\n");
            System.err.println("User Object Info >>>>>>>>>>>>>>>>>>>>\n");
            treeTableDisplay.printDisplay();
            System.err.println("########### DONE ###########\n\n");
        }
        if (treeTableDisplay != null) {
            return this.getTableDescriptors(treeTableDisplay);
        }
        return new TreeTableNodeDescriptor[0];
    }

    private TreeTableNodeDescriptor[] getTableDescriptors(TreeTableDisplay treeTableDisplay) {
        TreeTableNodeDescriptor[] treeTableNodeDescriptorArray = new TreeTableNodeDescriptor[treeTableDisplay.getNumChildren()];
        ListIterator listIterator = treeTableDisplay.getChildrenInfo();
        int n = 0;
        if (listIterator != null) {
            while (listIterator.hasNext()) {
                TreeTableDisplay treeTableDisplay2 = (TreeTableDisplay)listIterator.next();
                treeTableDisplay2.setParent(treeTableDisplay.getKey());
                treeTableNodeDescriptorArray[n++] = this.getTableDescriptor(treeTableDisplay2);
            }
        }
        return treeTableNodeDescriptorArray;
    }

    private TreeTableNodeDescriptor getTableDescriptor(TreeTableDisplay treeTableDisplay) {
        String string;
        ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[this.m_numColumns];
        int n = 0;
        String string2 = treeTableDisplay.getKey();
        String string3 = this.m_rootKey + string2 + KEY_SEPARATOR;
        int n2 = treeTableDisplay.getNumChildren();
        if (IDebug.enabled()) {
            System.err.println("@@@@@@@@ TreeTable @@@@@@@@\ngetTableDescriptor() <<<<<<");
            System.err.println("Get Table Descriptor >>  Display = " + treeTableDisplay.getKey());
        }
        if (this.m_nodeList.containsKey(string2)) {
            if (IDebug.enabled()) {
                System.err.println(">>>>>>>>>>>> Element already in tree!!!! <<<<<<<<<<<<");
            }
            return (TreeTableNodeDescriptor)this.m_nodeList.get(string2);
        }
        HashMap hashMap = treeTableDisplay.getRowData();
        if (hashMap != null) {
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                n = this.m_columnList.indexOf(string4);
                if (n < 0) continue;
                string = hashMap.get(string4);
                if (string == null) {
                    string = new String("");
                }
                itemDescriptorArray[n] = new ItemDescriptor(string3 + KEY_SEPARATOR + n, string.toString());
            }
        }
        this.fillItems(itemDescriptorArray, string3);
        string = treeTableDisplay.getValue();
        String string5 = treeTableDisplay.getIcon();
        TreeTableNodeDescriptor treeTableNodeDescriptor = this.createNode(string2, string.toString(), itemDescriptorArray, string5, treeTableDisplay);
        if (n2 > 0) {
            treeTableNodeDescriptor.setLeaf(false);
        } else {
            treeTableNodeDescriptor.setLeaf(true);
        }
        if (IDebug.enabled()) {
            System.err.println("@@@@@@@@ TreeTable @@@@@@@@\ngetTableDescriptor() >>>>>>>");
        }
        return treeTableNodeDescriptor;
    }

    private void fillItems(ItemDescriptor[] itemDescriptorArray, String string) {
        for (int i = 0; i < this.m_numColumns; ++i) {
            if (itemDescriptorArray[i] != null) continue;
            itemDescriptorArray[i] = new ItemDescriptor(string + KEY_SEPARATOR + i, " ");
        }
    }

    public ArrayList getNodePath(TreeTableNodeDescriptor treeTableNodeDescriptor) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TreeTableDisplay treeTableDisplay = (TreeTableDisplay)treeTableNodeDescriptor.getUserObject();
        String string = treeTableDisplay.getParent();
        if (string == null) {
            arrayList.add(this.m_rootName);
            return arrayList;
        }
        if (string != null) {
            arrayList2.add(treeTableDisplay.getKey());
            while (string != this.m_rootName) {
                TreeTableNodeDescriptor treeTableNodeDescriptor2 = (TreeTableNodeDescriptor)this.m_nodeList.get(string);
                TreeTableDisplay treeTableDisplay2 = (TreeTableDisplay)treeTableNodeDescriptor2.getUserObject();
                arrayList2.add(treeTableDisplay2.getKey());
                treeTableDisplay = treeTableDisplay2;
                string = treeTableDisplay.getParent();
            }
        }
        if (arrayList2.size() > 1) {
            stringArray = arrayList2.toArray(new String[0]);
            for (int i = stringArray.length - 1; i >= 0; --i) {
                arrayList.add(stringArray[i]);
            }
        } else {
            arrayList = arrayList2;
        }
        stringArray = arrayList.iterator();
        System.err.println("Path is : ");
        while (stringArray.hasNext()) {
            System.err.println(stringArray.next());
        }
        return arrayList;
    }

    public void addNodes(TreeTableDisplay[] treeTableDisplayArray) {
        if (this.m_utm != null) {
            for (int i = 0; i < treeTableDisplayArray.length; ++i) {
                this.addNode(treeTableDisplayArray[i]);
            }
        }
    }

    private void addNode(TreeTableDisplay treeTableDisplay) {
        String string;
        if (treeTableDisplay.getParent() == null) {
            string = this.m_rootName;
            treeTableDisplay.setParent(this.m_rootName);
        } else {
            string = treeTableDisplay.getParent();
        }
        try {
            TreeTableNodeDescriptor treeTableNodeDescriptor = (TreeTableNodeDescriptor)this.m_nodeList.get(string);
            TreeTableDisplay treeTableDisplay2 = (TreeTableDisplay)treeTableNodeDescriptor.getUserObject();
            System.err.println("Add Nodes >> Parent Name >>" + treeTableNodeDescriptor.getName() + "<<");
            System.err.println("Add Nodes >> Child Name >>" + treeTableDisplay.getKey() + "<<");
            if (!this.m_nodeList.containsKey(treeTableDisplay.getKey())) {
                System.err.println("Add Nodes >>  adding node >> ");
                treeTableDisplay.printDisplay();
                treeTableDisplay2.addChild(treeTableDisplay);
                try {
                    TreeTableNodeDescriptor treeTableNodeDescriptor2 = this.getTableDescriptor(treeTableDisplay);
                    treeTableNodeDescriptor2.setExpandRequested(true);
                    this.m_utm.addNode("TreeTable2", treeTableNodeDescriptor.getName(), null, (NodeDescriptor)treeTableNodeDescriptor2);
                }
                catch (TaskDefinitionException taskDefinitionException) {
                    System.err.println("Exception caught adding Node!!!!");
                    taskDefinitionException.printStackTrace();
                }
            }
            if (treeTableDisplay.getNumChildren() > 0) {
                ListIterator listIterator = treeTableDisplay.getChildrenInfo();
                while (listIterator.hasNext()) {
                    this.addNode((TreeTableDisplay)listIterator.next());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeNodes(TreeTableNodeDescriptor[] treeTableNodeDescriptorArray) {
        if (treeTableNodeDescriptorArray != null) {
            for (int i = 0; i < treeTableNodeDescriptorArray.length; ++i) {
                this.removeNode(treeTableNodeDescriptorArray[i]);
            }
        }
    }

    public void removeNode(TreeTableNodeDescriptor treeTableNodeDescriptor) {
        try {
            TreeTableDisplay treeTableDisplay = (TreeTableDisplay)treeTableNodeDescriptor.getUserObject();
            if (treeTableDisplay != null && this.m_nodeList.containsKey(treeTableDisplay.getKey())) {
                TreeTableNodeDescriptor treeTableNodeDescriptor2;
                String string = treeTableDisplay.getParent();
                System.err.println("Remove Nodes >> Parent Name >>" + string + "<<");
                System.err.println("Remove Nodes >> Child Name >>" + treeTableDisplay.getKey() + "<<");
                if (treeTableDisplay.getNumChildren() > 0) {
                    ListIterator listIterator = treeTableDisplay.getChildrenInfo();
                    while (listIterator.hasNext()) {
                        TreeTableDisplay treeTableDisplay2 = (TreeTableDisplay)listIterator.next();
                        this.removeNode((TreeTableNodeDescriptor)this.m_nodeList.get(treeTableDisplay2.getKey()));
                    }
                }
                if (string != null && (treeTableNodeDescriptor2 = (TreeTableNodeDescriptor)this.m_nodeList.get(string)) != null) {
                    this.m_nodeList.remove(treeTableDisplay.getKey());
                    TreeTableDisplay treeTableDisplay3 = (TreeTableDisplay)treeTableNodeDescriptor2.getUserObject();
                    if (treeTableDisplay3 != null) {
                        treeTableDisplay3.removeChild(treeTableDisplay);
                    }
                    if (treeTableDisplay3.getNumChildren() == 0 && string != this.m_rootName) {
                        this.removeNode(treeTableNodeDescriptor2);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printTree() {
        System.err.println("HashMap Nodes : " + this.m_nodeList);
    }
}

